;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeWithNoRootFeature.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.8  $
;          $Date:   29 Nov 2006 18:31:54  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeWithNoRootFeature.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; This example shows how you can prevent MAKEMSI from creating its
; "COMPLETE" feature so that you have full control over feature creation.
;
; The doco is normally added to the complete feature so you need to do
; something about this.
;
; This example allows the doco to be added so that we must also create
; a "blank" feature for it. To stop the doco being added you could
; define "COMPANY_WANT_TO_INSTALL_DOCUMENTATION" to be "Y" (without quotes!).
;
; Rather than create a specific feature for the doco you could also let
; MAKEMSI use any feature of yours which is always installed.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Include MAKEMSI support (with my customisations and MSI branding) ------
;----------------------------------------------------------------------------
#define  COMPANY_WANT_COMPLETE_FEATURE  N                       ;;I want total control over feature creation!
#define  COMPANY_HTMLRPT_FEATURE        Feature4MakemsiDoco     ;;We need to tell MAKEMSI which feature is to get the documentation.
#define  VER_FILENAME.VER               TryMe.Ver               ;;I only want one VER file for all samples!
#include "ME.MMH"


;----------------------------------------------------------------------------
;--- Simplistic Feature 1 ---------------------------------------------------
;----------------------------------------------------------------------------
<$Feature "Files_TryMe" Title=^Tryme.* Files^>
   ;--- Create INSTALLDIR ---------------------------------------------------
   <$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">

   ;--- Add the files (components generated) --------------------------------
   <$Files "TryMe.*" DestDir="INSTALLDIR">
<$/Feature>


;----------------------------------------------------------------------------
;--- Simplistic Feature 2 ---------------------------------------------------
;----------------------------------------------------------------------------
<$Feature "Files_TryMeWithNoRootFeature.MM" Title=^The TryMeWithNoRootFeature.MM File^ Directory_="INSTALLDIR">
   <$Files "TryMeWithNoRootFeature.MM" DestDir="INSTALLDIR">
<$/Feature>


;----------------------------------------------------------------------------
;--- Create feature into which MAKEMSI will add the doco --------------------
;----------------------------------------------------------------------------
#(
    ;--- If you don't want to do this more "COMPANY" config required... -----
    <$Feature "<$COMPANY_HTMLRPT_FEATURE>"
                   Title=^Feature for doco^
              Directory_=^<$COMPANY_HTMLRPT_DOCO_INSTALL_DIR_KEY>^
              Attributes="UIDisallowAbsent DisallowAdvertise"
    >
    <$/Feature>
#)


;---[4DocoComponentsInMultipleFeatures]---
;-----------------------------------------------------------------------------------------------------
;--- SAMPLE METHOD #1: Create Component (not nested "within" a feature) , add to multiple features ---
;-----------------------------------------------------------------------------------------------------
<$Component "This.Component.Is.In.Mult.Features" FEATURE="Files_TryMe,Files_TryMeWithNoRootFeature.MM" Create="Y" Directory_="INSTALLDIR" LM="Y">
    ;--- Whatever here ------------------------------------------------------
<$/Component>


;----------------------------------------------------------------------------
;--- SAMPLE METHOD #2: Map existing component to one or more features -------
;----------------------------------------------------------------------------
<$Feature "YetAnotherFeature1" Title=^SAMPLE METHOD #2 - Feature 1^>
    ;--- Add existing component to "enclosing" feature ----------------------
    <$Component "This.Component.Is.In.Mult.Features" CREATE="N"><$/Component>
<$/Feature>
<$Feature "YetAnotherFeature2" Title=^SAMPLE METHOD #2 - Feature 2^>
<$/Feature>
<$Feature "YetAnotherFeature3" Title=^SAMPLE METHOD #2 - Feature 3^>
    ;--- Add existing component to current plus a named feature -------------
    <$Component "This.Component.Is.In.Mult.Features" FEATURE=".,YetAnotherFeature2" CREATE="N"><$/Component>
<$/Feature>


;----------------------------------------------------------------------------
;--- SAMPLE METHOD #3: Table/Row to update assignment directly --------------
;----------------------------------------------------------------------------
<$Table "FeatureComponents">
    <$Row Feature_=^<$COMPANY_HTMLRPT_FEATURE>^ Component_=^This.Component.Is.In.Mult.Features^>
<$/Table>
;---[4DocoComponentsInMultipleFeatures]---